% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krull2024.R
\docType{data}
\name{krull2024}
\alias{krull2024}
\title{Krull et al, 2024 (Nature Communications): IFN-\eqn{\gamma} response}
\format{
A \link{QFeatures} object with 159 assays, each assay being a
\link{SingleCellExperiment} object.
\itemize{
\item Assay 1-158: DIA-NN main output report table split for each
acquisition run. First 15 run acquires 10 single cells (MEs) and,
remaining 143 run acquires 1 single cell. It contains the results
of the spectrum identification and quantification.
\item \code{proteins}: DIA-NN protein group matrix, containing normalised
quantities for 1553 protein groups in 143 single cells. Proteins
are filtered at (Q.Value <= 0.01), (Lib.Q.Value <= 0.01), and
(Lib.PG.Q.Value <= 0.01).
}

The \code{colData(krull2024())} contains cell type annotations. The description
of the \code{rowData} fields for the different assays can be found in the
\href{https://github.com/vdemichev/DiaNN#readme}{\code{DIA-NN} documentation}.
}
\source{
The data were downloaded from PRIDE
\href{https://www.ebi.ac.uk/pride/archive/projects/PXD053464}{repository}
with accession ID \code{PXD053464}.
}
\usage{
krull2024
}
\description{
They develop a new strategy for data-independent acquisition (DIA) that
leverages the co-analysis of low-input samples alongside a corresponding
enhancer (ME) of higher input. Using DIA-ME, they investigate the
proteomic response of U-2 OS cells to interferon gamma (IFN-\eqn{\gamma}) at
the single-cell level.
}
\section{Acquisition protocol}{


The data were acquired using the following setup. More information
can be found in the source article (see \code{References}).
\itemize{
\item \strong{Cell isolation}: cells were detached with trypsin digestion, followed
by dilution in 1.5 mL PBS, and isolated using BD FACSAria III instrument.
\item \strong{Sample preparation}: Sorted single cells were collected in lysis
buffer (50 mM TEAB, pH 8.5, and 0.025\% DDM), denatured at 70 degrees
Celsius for 30 minutes. Samples were acidified with 0.5\% FA and
transferred to auto sampler plates for mass spectrometry analysis.
\item \strong{Separation}: Peptides were injected in a 2 microliter volume onto
a (25 cm x 75  micrometer) ID column at a flow rate of 300 nL/min,
separated using a gradient of ACN in water with 0.1\% FA over 15 minutes,
connected to a nano-ESI source.
\item \strong{Ionization}: Ionization was performed using a 1,500 V capillary
voltage with 3.0 L/min dry gas and a dry temperature of 180 degrees
Celsius. MS data acquisition was conducted in diaPASEF mode using a
timsTOF Pro mass spectrometer.
\item \strong{Mass spectrometry}: MS1 scans covered a range of 200-1,700 m/z,
while DIA window isolation targeted 475-1,000 m/z with eight DIA scans
per cycle. Fragmentation was triggered by collision energy ranging from
45 eV to 27 eV depending on the ion mobility.
\item \strong{Data analysis}: Data was processed using DIA-NN (v1.8.0) and
Spectronaut 18 in a library-free approach, using deep learning
for spectrum prediction, retention times, and ion mobility.
}
}

\section{Data collection}{


The data were collected from the PRIDE
\href{https://www.ebi.ac.uk/pride/archive/projects/PXD053464}{repository}
in the \verb{03_SingleCell_Searches.zip} file.

We loaded the DIA-NN main report table and generated a sample
annotation table based on the MS file names. We next combined the
sample annotation and the DIANN tables into a \link{QFeatures} object
following the \code{scp} data structure. We loaded the proteins group
matrix as a \link{SingleCellExperiment} object, and added the protein data
as a new assay and link the precursors to proteins using the
\code{Protein.Group} variable from the \code{rowData}.
}

\examples{
\donttest{
krull2024()
}

}
\references{
Krull, K. K., Ali, S. A., & Krijgsveld, J. 2024. "Enhanced feature matching
in single-cell proteomics characterizes IFN-\eqn{\gamma} response and co-existence of
Cell States." Nature Communications, 15(1).
\href{https://doi.org/10.1038/s41467-024-52605-x}{Link to article}
}
\keyword{datasets}
