#' Example expression matrix for scTHI.
#'
#' A 21673 x 5527 matrix patient PatientBCH836 form Filbin,
#' M. G., Tirosh, I.,
#' Hovestadt, V., Shaw, M. L.,
#' Escalante, L. E., Mathewson, N. D., ... & Haberler, C. (2018).
#' Developmentaland oncogenic programs in H3K27M
#' gliomas dissected by single-cell RNA-seq.
#' Science, 360(6386), 331-335.
#' H3K27
"H3K27"


#' Example expression matrix for scTHI.
#'
#' A 17584  x 608 matrix patient PatientBCH836 form
#' Venteicher AS, Tirosh I, Hebert C, Yizhak K et al.
#' Decoupling genetics, lineages, and microenvironment
#' in IDH-mutant gliomas by single-cell RNA-seq.
#' Science 2017 Mar 31;355(6332)
#' MGH45
"MGH45"


#' Annotation for Example expression matrix for scTHI.
#'
#' A 608 x 2 dataframe with the annotation for the MGH4 matrix
#' Venteicher AS, Tirosh I, Hebert C, Yizhak K et al.
#' Decoupling genetics, lineages, and microenvironment
#' in IDH-mutant gliomas by single-cell RNA-seq.
#' Science 2017 Mar 31;355(6332)
#' MGH45.annotation
"MGH45.annotation"

#' Annotation for the H3K27 e expression matrix for scTHI.
#'
#' A dataframe 527x9 for the  matrix of patient PatientBCH836 form Filbin,
#' M. G., Tirosh, I.,
#' Hovestadt, V., Shaw, M. L.,
#' Escalante, L. E., Mathewson, N. D., ... & Haberler, C. (2018).
#' Developmentaland oncogenic programs in H3K27M
#' gliomas dissected by single-cell RNA-seq.
#' Science, 360(6386), 331-335.
#' H3K27.annotation
"H3K27.meta"

#' Example expression matrix for scTHI.
#'
#' A 2000 x 100 matrix from the wiki manual to showcase the use of scTHI
#' scExample 
"scExample"