% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KolodziejczykESCData.R
\name{KolodziejczykESCData}
\alias{KolodziejczykESCData}
\title{Obtain the Kolodziejcyzk ESC data}
\usage{
KolodziejczykESCData(remove.htseq = TRUE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{remove.htseq}{Logical scalar indicating whether HT-seq alignment statistics should be removed.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the mouse embryonic stem cell single-cell RNA-seq data from Kolodziejczyk et al. (2015).
}
\details{
Column metadata is generated from the column names,
and contains the culture conditions and the plate of origin for each cell.

Count data for ERCC spike-ins are stored in the \code{"ERCC"} entry in the \code{\link[SingleCellExperiment]{altExps}}.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/kolodziejczyk-esc}.
}
\examples{
sce <- KolodziejczykESCData()

}
\references{
Messmer T et al. (2019). 
Transcriptional heterogeneity in naive and primed human pluripotent stem cells at single-cell resolution. 
\emph{Cell Rep} 26(4), 815-824.e4
}
\author{
Aaron Lun
}
