% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AztekinTailData.R
\name{AztekinTailData}
\alias{AztekinTailData}
\title{Obtain the Aztekin tail data}
\usage{
AztekinTailData(legacy = FALSE)
}
\arguments{
\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the Xenopus tail single-cell RNA-seq data from Aztekin et al. (2019).
}
\details{
Column metadata is provided in the same form as supplied in E-MTAB-7761.
This contains information such as the treatment condition, batch, putative cell type, putative cell cycle phase.

The UMAP results are available as the \code{"UMAP"} entry in the \code{\link[SingleCellExperiment]{reducedDims}}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/aztekin-tail}.
}
\examples{
sce <- AztekinTailData()

}
\references{
Aztekin C et al. (2019).
Identification of a regeneration-organizing cell in the Xenopus tail.
\emph{Science} 364(6441), 653-658
}
\author{
Aaron Lun
}
