% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LunSpikeInData.R
\name{LunSpikeInData}
\alias{LunSpikeInData}
\title{Obtain the Lun spike-in data}
\usage{
LunSpikeInData(
  which = c("416b", "tropho"),
  split.oncogene = FALSE,
  location = TRUE,
  legacy = FALSE
)
}
\arguments{
\item{which}{String specifying whether the 416B or trophoblast data should be obtained.}

\item{split.oncogene}{Logical scalar indicating whether the oncogene should be split to a separate \code{\link[SingleCellExperiment]{altExp}}.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the spike-in single-cell RNA-seq data from Lun et al. (2017).
}
\details{
Row data contains a single \code{"Length"} field describing the total exonic length of each feature.

Column metadata is provided in the same form as supplied in E-MTAB-5522.
This contains information such as the cell type, plate of origin, spike-in addition order and oncogene induction. 

Two sets of spike-ins were added to each cell in each dataset.
These are available as the \code{"SIRV"} and \code{"ERCC"} entries in the \code{\link[SingleCellExperiment]{altExps}}.

If \code{split.oncogene=TRUE} and \code{which="416b"},
the CBFB-MYH11-mcherry oncogene is moved to extra \code{"oncogene"} entry in the \code{\link[SingleCellExperiment]{altExps}}.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/lun-spikein}.
}
\examples{
sce <- LunSpikeInData()

sce <- LunSpikeInData("tropho")

}
\references{
Lun ATL et al. (2017). 
Assessing the reliability of spike-in normalization for analyses of single-cell RNA sequencing data. 
\emph{Genome Res.} 27(11), 1795-1806.
}
\author{
Aaron Lun
}
