% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scMultiome-package.R
\docType{package}
\name{scMultiome-package}
\alias{scMultiome}
\alias{scMultiome-package}
\title{scMultiome: Collection of Public Single-Cell Multiome (scATAC + scRNAseq) Datasets}
\description{
Single cell multiome data, containing chromatin accessibility (scATAC-seq) and gene expression (scRNA-seq) information analyzed with the ArchR package and presented as MultiAssayExperiment objects.
}
\details{
Single cell multiome data sets, paired and unpaired, were analyzed
with the \code{ArchR} package in order to obtain epiregulons.
\code{ArchR} projects were converted to \code{MultiAssayExperiment} objects.

The creation of all datasets is described in detail in respective help files.
Run \code{listDatasets()} to view a list of available data sets or see \code{Datasets} below.
See \code{?<DATASET_NAME>} for details on particular data sets, e.g. \code{?prostateENZ}.
}
\section{Datasets}{

\itemize{
\item \strong{AR_drug}: Response of prostate cancer cells to drug treatment
\item \strong{colonHealthy}: Single-cell analysis of samples from healthy human colon
\item \strong{hematopoiesis}: scATAC-seq and unpaired scRNA-seq of hematopoetic cells
\item \strong{PBMC_10x}: PBMC Data Set
\item \strong{prostateENZ}: LNCaP Cells Treated with Enzalutamide
\item \strong{reprogramSeq}: Reprogram-seq of LNCaP cells
\item \strong{TEADi_resistance}: Resistance of TEAD inhibitor to drug
\item \strong{tfBinding_hg19_atlas}: TF Binding Info hg19 (ChIP-Atlas and ENCODE)
\item \strong{tfBinding_hg19_atlas.sample}: TF Binding Info hg19 by sample (ChIP-Atlas)
\item \strong{tfBinding_hg19_atlas.sample_v2}: TF Binding Info hg19 by sample (ChIP-Atlas)
\item \strong{tfBinding_hg19_atlas.tissue}: TF Binding Info hg19 by tissue (ChIP-Atlas)
\item \strong{tfBinding_hg19_atlas.tissue_v2}: TF Binding Info hg19 by tissue (ChIP-Atlas)
\item \strong{tfBinding_hg19_encode.sample}: TF Binding Info hg19 by sample (ENCODE)
\item \strong{tfBinding_hg19_encode.sample_v2}: TF Binding Info hg19 by sample (ENCODE)
\item \strong{tfBinding_hg38_atlas}: TF Binding Info hg38 (ChIP-Atlas and ENCODE)
\item \strong{tfBinding_hg38_atlas.sample}: TF Binding Info hg38 by sample (ChIP-Atlas)
\item \strong{tfBinding_hg38_atlas.sample_v2}: TF Binding Info hg38 by sample (ChIP-Atlas)
\item \strong{tfBinding_hg38_atlas.tissue}: TF Binding Info hg38 by tissue (ChIP-Atlas)
\item \strong{tfBinding_hg38_atlas.tissue_v2}: TF Binding Info hg38 by tissue (ChIP-Atlas)
\item \strong{tfBinding_hg38_encode.sample}: TF Binding Info hg38 by sample (ENCODE)
\item \strong{tfBinding_hg38_encode.sample_v2}: TF Binding Info hg38 by sample (ENCODE)
\item \strong{tfBinding_mm10_atlas}: TF Binding Info mm10 (ChIP-Atlas and ENCODE)
\item \strong{tfBinding_mm10_atlas.sample}: TF Binding Info mm10 by sample (ChIP-Atlas)
\item \strong{tfBinding_mm10_atlas.sample_v2}: TF Binding Info mm10 by sample (ChIP-Atlas)
\item \strong{tfBinding_mm10_atlas.tissue}: TF Binding Info mm10 by tissue (ChIP-Atlas)
\item \strong{tfBinding_mm10_atlas.tissue_v2}: TF Binding Info mm10 by tissue (ChIP-Atlas)
\item \strong{tfBinding_mm10_encode.sample}: TF Binding Info mm10 by sample (ENCODE)
\item \strong{tfBinding_mm10_encode.sample_v2}: TF Binding Info mm10 by sample (ENCODE)
\item \strong{human_pwms_v2}: TF motifs human
\item \strong{mouse_pwms_v2}: TF motifs mouse
}
}

\author{
\strong{Maintainer}: Xiaosai Yao \email{xiaosai.yao@gmail.com} (\href{https://orcid.org/0000-0001-9729-0726}{ORCID})

Authors:
\itemize{
  \item Aleksander Chlebowski \email{aleksander.chlebowski@contractors.roche.com}
  \item Aaron Lun \email{lun.aaron@gene.com}
  \item Tomasz Włodarczyk \email{tomasz.wlodarczyk@contractors.roche.com}
}

Other contributors:
\itemize{
  \item Shiqi Xie \email{xie.shiqi@gene.com} [contributor]
}

}
\keyword{internal}
