% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileOperations.R
\name{fileOperations}
\alias{fileOperations}
\alias{saveMAE}
\alias{loadMAE}
\alias{saveExp}
\alias{saveExp,SummarizedExperiment-method}
\alias{saveExp,SingleCellExperiment-method}
\alias{loadExp}
\alias{testFile}
\alias{uploadFile}
\title{save and load data sets}
\usage{
saveMAE(mae, file, experiments = NULL, verbose = TRUE, overwrite = FALSE)

loadMAE(file, experiments, verbose)

saveExp(exp, expName, file, verbose)

\S4method{saveExp}{SummarizedExperiment}(exp, expName, file, verbose)

\S4method{saveExp}{SingleCellExperiment}(exp, expName, file, verbose)

loadExp(file, expName, verbose)

testFile(file)

uploadFile(
  file,
  sasToken,
  endpoint = "https://bioconductorhubs.blob.core.windows.net"
)
}
\arguments{
\item{mae}{object of class \code{MultiAssayExperiment}}

\item{file}{path to a hdf5 file}

\item{experiments}{character string specifying which experiments to save/load}

\item{verbose}{logical flag specifying operation verbosity}

\item{overwrite}{logical flag specifying whether to allow overwriting the hdf5 file}

\item{exp}{an experiment object that inherits from class \code{SummarizedExperiment},
usually a \code{SingleCellExperiment}}

\item{expName}{name of the experiment, i.e. name of the \code{ArchR} Matrix}

\item{sasToken}{access token to \code{endpoint}}

\item{endpoint}{Bioconductor's data bucket endpoint url}
}
\value{
\code{saveExp} returns \code{TRUE} invisibly if the save was successful.
\code{saveMAE} returns a named list of \code{TRUE} values.
\code{loadExp} returns a \code{SingleCellExperiment} or an object of a subclass.
\code{loadMAE} returns a \code{MultiAssayExperiment}.
\code{testFile} returns the \code{MultiAssayExperiment} stored in \code{file} in its entirety.
\code{uploadFile} returns TRUE invisibly.
}
\description{
Functions to disassemble and save, and load and reassemble MultiAssayExperiment data sets.
}
\details{
These are utilities for developers to add new data sets to the package.
Most will usually be called internally.

\code{saveMAE} is used to save a \code{MultiAssayExperiment} to a hdf5 file.
It creates the \code{file} and passes individual \code{experiments} to \code{saveExp}.

\code{saveExp} is called by \code{saveMAE} to disassemble experiment \code{exp}
and save its elements in \code{file}. A group hierarchy is created with
the top level group called \code{expName}, e.g. "GeneScoreMatrix",
and lower level groups to store specific elements:
\itemize{
\item{\code{experiment} class is saved in group "class"}
\item{assays are saved as sparse matrices in subgroup "assays", using \code{writeSparseMatrix}}
\item{\code{colData} and \code{colnames} are saved in subgroup "properties"}
\item{if \code{experiment} has \code{rownames}, the are saved in "properties"}
\item{\code{rowData} is saved in "properties", unless it is an empty \code{DataFrame}}
\item{if \code{experiment} has a \code{rowRanges} component,
it is converted to a data frame and saved in "properties"}
\item{if \code{experiment} has a \code{metadata} component,
it is deparsed to a string and saved in "properties"}
\item{if \code{experiment} has a \code{reducedDims} component,
they are saved in subgroup "reducedDims"}
\item{if \code{experiment} has a \code{altExps} component,
they are saved in subgroup "altExps" by recursively calling \code{saveExp}}
}
\code{DataFrames} (e.g. \code{colData}, \code{rowData}, embeddings)
are converted to \code{data.frames} and saved as compound type.

\code{loadMAE} is called by accessor functions to retrieve data. It locates the hdf5 file
in which the data set is stored and uses \code{loadExp} to extract the specified \code{experiments}.

\code{loadExp} first checks which property elements are stored for the experiment in question,
loads all elements of the experiment and builds a \code{SummarizedExperiment} object.
If the experiment was originally a \code{SingleCellExperiment} or a subclass thereof,
that class as well as possible additional slots are restored.

\code{testFile} can be used to test whether a data set loads correctly from a local file.
It calls \code{loadMAE} and extracts all experiment verbosely.

\code{uploadFile} will upload a single file to Bioconductor's staging directory.
}
\examples{

# create dummy MultiAssayExperiment
mae <- scMultiome:::dummyMAE()

fileName <- tempfile(fileext = ".h5")
saveMAE(mae, fileName)                                # save MAE
remae <- loadMAE(fileName, c("EXP1", "EXP2"), TRUE)   # load MAE (internal)
remae_exp1 <- loadMAE(fileName, "EXP1", TRUE)         # load MAE with one experiment (internal)

# create dummy SingleCellExperiment
sce <- scMultiome:::dummySCE()

saveExp(sce, "EXP3", fileName, TRUE)                  # save one experiment (internal)
resce <- loadExp(fileName, "EXP3", TRUE)              # load one experiment (internal)

testFile(fileName)                                    # load whole MAE
}
\seealso{
Vignette "rhdf5 - HDF5 interface for R" (\code{vignette} or \code{browseVignettes})
for details of hdf5 file construction.
\code{writeSparseMatrix} for details of saving sparse matrices.
}
\author{
Aleksander Chlebowski and Xiaosai
}
