% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{loadPartialCorProt}
\alias{loadPartialCorProt}
\title{Load PartialCorProt data}
\source{
FloresData_K_TK study. Original data processed for iModMix.
}
\usage{
loadPartialCorProt()
}
\value{
A \code{data.frame} with proteins as rows and samples as columns.
}
\description{
Loads the PartialCorProt dataset from ExperimentHub.
}
\details{
The dataset contains partial correlation values between proteins derived
from the FloresData_K_TK study.
Data were preprocessed similarly to genes and metabolites:
\itemize{
\item Filtering features with >10\% missing values
\item Removing features with low variance
\item Scaling and KNN imputation of missing values
}

Partial correlations were calculated using \code{partial_cors()} with rho = 0.25.

Rows correspond to proteins, columns correspond to samples. Each entry
represents the partial correlation of the protein with other proteins,
adjusted for covariates.
}
\examples{
proteins <- loadPartialCorProt()
head(proteins)
dim(proteins)
}
