### =========================================================================
### depmap metadata 19Q3 data 
### -------------------------------------------------------------------------
### this script generates the metadata_19Q3.csv
## note: this script assumes that your current directory is depmap/inst/scripts/

meta_19Q3 <- data.frame(
    Title = c(paste0("rnai_19Q3"),
              paste0("crispr_19Q3"), 
              paste0("copyNumber_19Q3"),
              paste0("RPPA_19Q3"), 
              paste0("TPM_19Q3"),
              paste0("mutationCalls_19Q3"),
              paste0("metadata_19Q3"),
              paste0("drug_sensitivity_19Q3")),
    Description = c(paste0("(DEMETER2) Batch and off-target corrected RNAi ", 
                           "gene knockdown dependency data for 17309 genes, ", 
                           "712 cancer cell lines, 31 primary Diseases and ", 
                           "31 lineages."), 
                    paste0("(CERES) Batch and off-target corrected CRISPR-Cas9 ", 
                           "gene knockdout dependency data for 18333 genes, ", 
                           "625 cell lines, 28 primary diseases and 29 ", 
                           "lineages."), 
                    paste0("WES log copy number data for 27562 genes, 1657 ", 
                           "cell lines, 36 primary diseases and 34 lineages."),
                    paste0("Reverse Phase Protein Array (RPPA) Western Blot ", 
                           "expression data from 214 genes, 899 cancer cell ", 
                           "lines, 28 primary diseases and 28 lineages."),
                    paste0("CCLE 'Transcript Per Million' (TPM) RNAseq gene ", 
                           "expression data (in scale scale (log2(TPM+1))) ", 
                           "for protein coding genes from 19144 genes, 1210 ", 
                           "cancer cell lines, 32 primary diseases and 33 ", 
                           "lineages."), 
                    paste0("Merged mutation calls (for coding region, germline ", 
                           "filtered) and includes data from 18798 genes, 1656 ", 
                           "cell lines, 36 primary diseases and 34 lineages. "),
                    paste0("Metadata for cell lines in the 19Q3 DepMap release, ", 
                           "for 0 genes, 1736 cell lines, 37 primary diseases ", 
                           "and 34 lineages."),
                    paste0("Drug sensitivity data for cancer cell lines ",
                           "derived from replicate collapsed logfold change ",
                           "values relative to DMSO, corrected for experimental ",
                           "confounders using ComBat representing 4686 compounds, ",
                           "578 cell lines, 23 primary diseases and 25 lineages")),
    BiocVersion = "3.10",
    Genome = "", 
    SourceType = "CSV", 
    SourceUrl = c(paste0("https://ndownloader.figshare.com/files/13515395"),
                  paste0("https://ndownloader.figshare.com/files/16757666"),
                  paste0("https://ndownloader.figshare.com/files/16757699"),
                  paste0("https://depmap.org/portal/download/api/download/external?file_name=ccle%2Fccle_2019%2FCCLE_RPPA_20181003.csv"),
                  paste0("https://ndownloader.figshare.com/files/16757690"),
                  paste0("https://ndownloader.figshare.com/files/16757702"),
                  paste0("https://ndownloader.figshare.com/files/16757723"),
                  paste0("https://ndownloader.figshare.com/files/17008628")),
    SourceVersion = "Aug 7 2019",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "Broad Institute",
    Maintainer = "Theo Killian <theodore.killian@uclouvain.be>",
    RDataClass = "tibble",
    DispatchClass = "Rda",
    RDataPath = c(paste0("depmap/rnai_19Q3.rda"), 
                  paste0("depmap/crispr_19Q3.rda"), 
                  paste0("depmap/copyNumber_19Q3.rda"), 
                  paste0("depmap/RPPA_19Q3.rda"), 
                  paste0("depmap/TPM_19Q3.rda"),
                  paste0("depmap/mutationCalls_19Q3.rda"),
                  paste0("depmap/metadata_19Q3.rda"),
                  paste0("depmap/drug_sensitivity_19Q3.rda")),
    Tags=paste0("ExperimentHub, ExperimentData, ReproducibleResearch, RepositoryData, AssayDomainData, ", 
                "CopyNumberVariationData, DiseaseModel, CancerData, BreastCancerData, ColonCancerData, ", 
                "KidneyCancerData, LeukemiaCancerData, LungCancerData, OvarianCancerData, ProstateCancerData", 
                "OrganismData, Homo_sapiens_Data, PackageTypeData, SpecimenSource, CellCulture, Genome, ", 
                "Proteome, StemCell, Tissue"),
    Notes = "This dataset is from the 19Q3 release")

write.csv(meta_19Q3, file="../extdata/metadata_19Q3.csv", row.names=FALSE)
## to upload this metadata to EH, enter the following into the CL
## ExperimentHubData::makeExperimentHubMetadata("~/tmp/depmap/", fileName = "metadata_19Q3.csv")