% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{curatedPCaDatasets_taylor}
\alias{curatedPCaDatasets_taylor}
\title{Taylor et al. MAE-object}
\format{
An MAE object spanning 218 men with prostate cancer
\describe{
    \item{cna.gistic}{matrix with 17832 rows and 194 columns, of gistic 
        values for copy number alteration data}
    \item{cna.logr}{matrix with 18062 rows and 218 columns, of log-ratios for
        copy number alteration data}
    \item{gex.rma}{matrix with 17410 rows and 179 columns, of gene expression
        data}
    \item{mut}{RaggedExperiment with 90 rows and 43 columns, of mutation 
        data}
    \item{cibersort}{matrix with 22 rows and 179 columns, of cibersort based 
        deconvolution data}
    \item{xcell}{matrix with 39 rows and 179 columns, of xcell based 
        deconvolution data}
    \item{epic}{matrix with 8 rows and 179 columns, of epic based 
        deconvolution data}
    \item{quantiseq}{matrix with 11 rows and 179 columns, of quantiseq based 
        deconvolution data}
    \item{estimate}{data.frame with 4 rows and 179 columns, of cell types 
        based on ESTIMATE method}
    \item{scores}{matrix with 4 rows and 179 columns, of risk scores and AR 
        scores}
    \item{mcp}{matrix with 11 rows and 179 columns, of mcp-counter based 
        deconvolution data}
}
}
\source{
\url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE21035}
}
\value{
A MultiAssayExperiment corresponding to the study and its available 
omics.
}
\description{
MultiAssayExperiment object containing gene expression (gex), copy
number alteration (cna), mutations and immune cell estimates from Taylor et 
al.
}
\details{
Note that there is lack of overlap between the omics provided for 
each sample.
}
\examples{
mae_taylor <- getPCa('taylor')
}
\references{
(\href{https://pubmed.ncbi.nlm.nih.gov/20579941/}{PubMed})
}
\keyword{datasets}
