% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{exampleTENETStep2GetDifferentiallyMethylatedSitesPuritySummarizedExperiment}
\alias{exampleTENETStep2GetDifferentiallyMethylatedSitesPuritySummarizedExperiment}
\title{Example TENET \code{step2GetDifferentiallyMethylatedSites} purity
SummarizedExperiment object}
\usage{
exampleTENETStep2GetDifferentiallyMethylatedSitesPuritySummarizedExperiment(
  metadata = FALSE
)
}
\arguments{
\item{metadata}{If TRUE, retrieve the ExperimentHub metadata instead of the
object itself. Defaults to FALSE.}
}
\value{
A SummarizedExperiment object with two methylation datasets,
"purityMethylationExampleA" and "purityMethylationExampleB", each containing
data for 20,000 HM450 probes in 10 samples.
}
\description{
A SummarizedExperiment object with three DNA methylation
datasets each composed of 10 adjacent normal colorectal adenocarcinoma
(COAD) samples from The Cancer Genome Atlas (TCGA), retrieved using the
TCGAbiolinks package. Each dataset has data for 20,000 probes from the
Illumina HM450 methylation array, to match the number of probes in the
\code{exampleTENETMultiAssayExperiment} object. The data are aligned to the human
hg38 genome. This object is representative of a \code{purity} dataset, which
would contain DNA methylation data from potentially confounding sources,
used with TENET's \code{step2GetDifferentiallyMethylatedSites} function.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
exampleTENETStep2GetDifferentiallyMethylatedSitesPuritySummarizedExperiment()
\dontshow{\}) # examplesIf}
}
