## ----echo = FALSE, message = FALSE--------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")
options(tibble.print_min = 4, tibble.print_max = 4, max.print = 4)

## ----eval = FALSE-------------------------------------------------------------
# ## Install BiocManager, which is required to install packages from Bioconductor
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# BiocManager::install("TENET.ExperimentHub")

## ----eval = FALSE-------------------------------------------------------------
# ## Install prerequisite packages to install the development version from GitHub
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# if (!requireNamespace("remotes", quietly = TRUE)) {
#     install.packages("remotes")
# }
# 
# BiocManager::install(version = "devel")
# BiocManager::install("rhielab/TENET.ExperimentHub")

## ----message = FALSE----------------------------------------------------------
library(TENET.ExperimentHub)

## -----------------------------------------------------------------------------
## Retrieve the ExperimentHub metadata for the object
exampleTENETMultiAssayExperiment(metadata = TRUE)

## Retrieve the object itself
exampleTENETMultiAssayExperiment()

## -----------------------------------------------------------------------------
## Retrieve the ExperimentHub metadata for the object
exampleTENETClinicalDataFrame(metadata = TRUE)

## Retrieve the object itself
exampleTENETClinicalDataFrame()

## -----------------------------------------------------------------------------
## Retrieve the ExperimentHub metadata for the object
exampleTENETStep1MakeExternalDatasetsGRanges(metadata = TRUE)

## Retrieve the object itself
exampleTENETStep1MakeExternalDatasetsGRanges()

## -----------------------------------------------------------------------------
## Retrieve the ExperimentHub metadata for the object
exampleTENETStep2GetDifferentiallyMethylatedSitesPuritySummarizedExperiment(
    metadata = TRUE
)

## Retrieve the object itself
exampleTENETStep2GetDifferentiallyMethylatedSitesPuritySummarizedExperiment()

## -----------------------------------------------------------------------------
## Retrieve the ExperimentHub metadata for the object
exampleTENETPeakRegions(metadata = TRUE)

## Retrieve the object itself
exampleTENETPeakRegions()

## -----------------------------------------------------------------------------
## Retrieve the ExperimentHub metadata for the object
exampleTENETTADRegions(metadata = TRUE)

## Retrieve the object itself
exampleTENETTADRegions()

## ----echo = FALSE, message = FALSE--------------------------------------------
## Reset max.print to the default to ensure the full session info is shown
options(max.print = 99999)

## -----------------------------------------------------------------------------
sessionInfo()

