% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGAWorkflowExampleData.R
\docType{package}
\name{TCGAWorkflowData}
\alias{TCGAWorkflowData}
\title{Data for TCGA Workflow}
\description{
This experimental data package has the data necessary to follow the
TCGA Workflow: Analyze cancer genomics and epigenomics data using Bioconductor packages.
It contains the following files:
\itemize{
  \item met20SamplesGBMLGGchr9:  DNA methylation matrix from Infinium
   HumanMethylation450 platform
    for 10 LGG (Lower grade glioma) and 10 GBM (Glioblastoma multiforme).
    It has only probes in chromossome 9  in order to make the example
    of the workflow faster
  \item elmerExample: Contains a DNA methylation matrix
    (only probes in chromossome 9) and a gene expression matrix for
    10  LGG (Lower grade glioma) and 10 GBM (Glioblastoma multiforme) in the required format
    for to execute the R/Bioconductor ELMER package analysis and a vector
    identifying which sample belongs to each tumor type.
   \item biogrid: biogrid information
  \item maf_lgg_gbm: Mutation annotation files for LGG
    (Lower grade glioma) and GBM (Glioblastoma multiforme)
    samples merged into a single matrix. The GDC Somatic Mutation Calling
    Workflow mutect2 was used to create this MAF files.
  \item  histoneMarks: histone marks specific for brain tissue using
  from Roadmap database.
  \item  genes_GR: A GRanges Object and a dataframe  with gene information
  (hg19) downloaded from ENSEMBLE database using
  biomart via TCGAbiolinks
  \item TCGA_GBM_Transcriptome_20_samples:  a matrix with  raw expression signal for
  expression of a gene for 20 GBM (Glioblastoma multiforme) samples
  \item TCGA_LGG_Transcriptome_20_samples:   a matrix with  raw expression signal for
  expression of a gene for 20 LGG (low grade glioma) samples
}
    For more information how to create these objects please read the vignette of this package with the
    follwing command: \code{browseVignettes("TCGAWorkflowData")}
}
\examples{
data("elmerExample")
data("TCGA_LGG_Transcriptome_20_samples")
data("TCGA_GBM_Transcriptome_20_samples")
data("histoneMarks")
data("biogrid")
data("genes_GR")
data("maf_lgg_gbm")
}
\keyword{utilities}
