% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellGating.R
\name{getCellGroups}
\alias{getCellGroups}
\title{getCellGroups}
\usage{
getCellGroups(mat, adt1 = "CD19", adt2 = "CD3", th1 = 0.2, th2 = 0)
}
\arguments{
\item{mat}{matrix of counts or clr transformed counts for ADT data in CITEseq}

\item{adt1}{character indicating the name of the marker to plot on the x-axis
(default is CD19).}

\item{adt2}{character indicating the name of the marker to plot on the y-axis
(default is CD3).}

\item{th1}{numeric indicating the threshold for the marker on the x-axis
(default is 0.2).}

\item{th2}{numeric indicating the threshold for the marker on the y-axis
(default is 0).}
}
\value{
a list of four different element, each one indicating the quarter
where the thresholds divide the plotting space, in eucledian order I, II,
III, IV quadrant, indicating respectively +/+, +/-, -/+, -/- combinations
for the couples of selected ADTs.
Each element of the list contains two objects, one with the list of detected
barcodes and one indicating the percentage of barcodes falling into that
quadrant.
.
}
\description{
Shows the cells/barcodes in two different plots (scatter and density)
divinding the space in four quadrant indicated by the two thresholds given
as input parameters.
The x/y-axis represent respectively the two ADTs given as input.
It returns a list of one element for each quadrant, each with barcodes and
percentage (see Value section for details).
}
\details{
helps to do manual gating for cell type indentification with CITEseq
or similar data, providing cell markers.
Once identified two interesting markers for a cell type, the user has to
play with the thresholds to identify the cell populations specified by an
uptake (+) o downtake (-) of the couple of markers (ADTs) previously selected.
}
