% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GTseq.R
\name{GTseq}
\alias{GTseq}
\title{Parallel sequencing data of single-cell genomes and transcriptomes}
\source{
\url{https://www.ebi.ac.uk/ena/browser/view/PRJEB9051}
}
\usage{
GTseq(
  DataType = "mouse_embryo_8_cell",
  modes = "*",
  version = "1.0.0",
  dry.run = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{DataType}{\code{character(1)} Indicates study that produces this type of
data (default: 'mouse_embryo_8_cell')}

\item{modes}{\code{character()} A wildcard / glob pattern of modes, such as
\code{"*omic"}. A wildcard of \code{"*"} will return all modes including
copy numbers ("genomic") and RNA-seq read counts ("transcriptomic"),
which is the default.}

\item{version}{\code{character(1)} Currently, only version '1.0.0'.}

\item{dry.run}{\code{logical(1)} Whether to return the dataset names before actual
download (default \code{TRUE})}

\item{verbose}{\code{logical(1)} Whether to show the dataset currently being
(down)loaded (default \code{TRUE})}

\item{...}{Additional arguments passed on to the
\link[ExperimentHub:ExperimentHub-class]{ExperimentHub} constructor}
}
\value{
A single cell multi-modal
\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment} or
informative \code{data.frame} when \code{dry.run} is \code{TRUE}
}
\description{
GTseq assembles data on-the-fly from \code{ExperimentHub} to provide
a
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
container. The \code{DataType} argument provides access to the
\code{mouse_embryo_8_cell} dataset as obtained from Macaulay et al. (2015).
Protocol information for this dataset is available from Macaulay et al.
(2016). See references.
}
\details{
G&T-seq is a combination of Picoplex amplified gDNA sequencing
(genome) and SMARTSeq2 amplified cDNA sequencing (transcriptome) of the
same cell. For more information, see Macaulay et al. (2015).
* mouse_embryo_8_cell:
this dataset was filtered for bad cells as specified in Macaulay
et al. (2015).
* genomic - integer copy numbers as detected from scDNA-seq
* transcriptomic - raw read counts as quantified from scRNA-seq
}
\section{metadata}{

The \code{MultiAssayExperiment} metadata includes the original function call
that saves the function call and the data version requested.
}

\examples{

GTseq()

}
\references{
Macaulay et al. (2015) G&T-seq: parallel sequencing of single-cell
genomes and transcriptomes. Nat Methods, 12:519–22.

Macaulay et al. (2016) Separation and parallel sequencing of the genomes
and transcriptomes of single cells using G&T-seq. Nat Protoc, 11:2081–103.
}
\seealso{
SingleCellMultiModal-package
}
