/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.framework.dag;

import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.measures.graph.framework.dag.Sim_Framework_DAG_Set_abstract;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class Sim_Framework_DAG_Set_Tversky_1977
extends Sim_Framework_DAG_Set_abstract {
    public static final String k_param_name = "k";
    private double k = 0.5;

    public Sim_Framework_DAG_Set_Tversky_1977() {
    }

    public Sim_Framework_DAG_Set_Tversky_1977(double k) {
        this.k = k;
    }

    @Override
    public double compare(Set<URI> ancA, Set<URI> ancB, SMconf conf) throws SLIB_Exception {
        if (conf != null && conf.containsParam(k_param_name)) {
            this.k = conf.getParamAsDouble(k_param_name);
        }
        Set<URI> interSecAncestors = SetUtils.intersection(ancA, ancB);
        HashSet<URI> diff_a_b = new HashSet<URI>(ancA);
        diff_a_b.removeAll(ancB);
        HashSet<URI> diff_b_a = new HashSet<URI>(ancB);
        diff_b_a.removeAll(ancA);
        int c1_c2_diff_size = diff_a_b.size();
        int c2_c1_diff_size = diff_b_a.size();
        double den = (double)interSecAncestors.size() + this.k * (double)c1_c2_diff_size + (1.0 - this.k) * (double)c2_c1_diff_size;
        double tversky = (double)interSecAncestors.size() / den;
        return tversky;
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    @Override
    public Boolean isSymmetric() {
        return this.k == 0.5;
    }
}

