/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.util.iterators.ConvertingIterator;

public class SPARQLQueryBindingSet
implements BindingSet {
    private static final long serialVersionUID = -2010715346095527301L;
    private final Map<String, Value> bindings;

    public SPARQLQueryBindingSet() {
        this(8);
    }

    public SPARQLQueryBindingSet(int capacity) {
        this.bindings = new HashMap<String, Value>(capacity * 2);
    }

    public SPARQLQueryBindingSet(BindingSet bindingSet) {
        this(bindingSet.size());
        this.addAll(bindingSet);
    }

    public void addAll(BindingSet bindingSet) {
        if (bindingSet instanceof SPARQLQueryBindingSet) {
            this.bindings.putAll(((SPARQLQueryBindingSet)bindingSet).bindings);
        } else {
            for (Binding binding : bindingSet) {
                this.addBinding(binding);
            }
        }
    }

    public void addBinding(Binding binding) {
        this.addBinding(binding.getName(), binding.getValue());
    }

    public void addBinding(String name, Value value) {
        assert (!this.bindings.containsKey(name)) : "variable already bound: " + name;
        this.setBinding(name, value);
    }

    public void setBinding(Binding binding) {
        this.setBinding(binding.getName(), binding.getValue());
    }

    public void setBinding(String name, Value value) {
        assert (value != null) : "null value for variable " + name;
        this.bindings.put(name, value);
    }

    public void removeBinding(String name) {
        this.bindings.remove(name);
    }

    public void removeAll(Collection<String> bindingNames) {
        this.bindings.keySet().removeAll(bindingNames);
    }

    public void retainAll(Collection<String> bindingNames) {
        this.bindings.keySet().retainAll(bindingNames);
    }

    @Override
    public Set<String> getBindingNames() {
        return this.bindings.keySet();
    }

    @Override
    public Value getValue(String bindingName) {
        return this.bindings.get(bindingName);
    }

    @Override
    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new BindingImpl(bindingName, value);
        }
        return null;
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.bindings.containsKey(bindingName);
    }

    @Override
    public Iterator<Binding> iterator() {
        Iterator<Map.Entry<String, Value>> entries = this.bindings.entrySet().iterator();
        return new ConvertingIterator<Map.Entry<String, Value>, Binding>(entries){

            @Override
            protected Binding convert(Map.Entry<String, Value> entry) {
                return new BindingImpl(entry.getKey(), entry.getValue());
            }
        };
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SPARQLQueryBindingSet) {
            return this.bindings.equals(((SPARQLQueryBindingSet)other).bindings);
        }
        if (other instanceof BindingSet) {
            int otherSize = 0;
            for (Binding binding : (BindingSet)other) {
                Value ownValue = this.getValue(binding.getName());
                if (!binding.getValue().equals(ownValue)) {
                    return false;
                }
                ++otherSize;
            }
            return otherSize == this.bindings.size();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Map.Entry<String, Value> entry : this.bindings.entrySet()) {
            hashCode ^= entry.getKey().hashCode() ^ entry.getValue().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32 * this.size());
        sb.append('[');
        Iterator<Binding> iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(';');
        }
        sb.append(']');
        return sb.toString();
    }
}

