/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.limited.iterator;

import info.aduna.iteration.Iteration;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.iterator.SPARQLMinusIteration;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeIteratorUtil;

public class LimitedSizeSPARQLMinusIteration
extends SPARQLMinusIteration<QueryEvaluationException> {
    private AtomicLong used;
    private long maxSize;

    public LimitedSizeSPARQLMinusIteration(Iteration<BindingSet, QueryEvaluationException> leftArg, Iteration<BindingSet, QueryEvaluationException> rightArg, AtomicLong used, long maxSize) {
        this(leftArg, rightArg, false, used, maxSize);
    }

    public LimitedSizeSPARQLMinusIteration(Iteration<BindingSet, QueryEvaluationException> leftArg, Iteration<BindingSet, QueryEvaluationException> rightArg, boolean distinct, AtomicLong used, long maxSize) {
        super(leftArg, rightArg, distinct);
        this.used = used;
        this.maxSize = maxSize;
    }

    @Override
    protected Set<BindingSet> makeSet(Iteration<BindingSet, QueryEvaluationException> rightArg2) throws QueryEvaluationException {
        return LimitedSizeIteratorUtil.addAll(rightArg2, this.makeSet(), this.used, this.maxSize);
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        long size = this.clearExcludeSet();
        super.handleClose();
        this.used.addAndGet(-size);
    }
}

