% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions_NGS.r
\name{twoPatternReadFilter}
\alias{twoPatternReadFilter}
\title{Filter input sequences for two patterns}
\usage{
twoPatternReadFilter(reads, leftPattern, rightPattern, maxMismatch,
  prevPatternPos = NULL)
}
\arguments{
\item{reads}{input sequences}

\item{leftPattern}{left pattern motive.}

\item{rightPattern}{right pattern motive.}

\item{maxMismatch}{maximal number of miss matches.}

\item{prevPatternPos}{prev pattern posiotion; default is set to NULL.}
}
\value{
list object
}
\description{
Filter input sequences for two patterns
}
\examples{
reads <- DNAStringSet(c('ACTGGGTTT','ACCCTGGGTTT'))
leftPattern <- 'CT'
rightPattern <- 'TTT'
maxMismatch <- 0
twoPatternReadFilter(reads, leftPattern, rightPattern, maxMismatch)
}
