% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose_GPx10R}
\alias{compose_GPx10R}
\title{Compose a peptide with a defined AA sequence}
\usage{
compose_GPx10R(aa_pool1, aa_pool2)
}
\arguments{
\item{aa_pool1}{AA distributen.}

\item{aa_pool2}{AA distributen.}
}
\value{
a AA sequence
}
\description{
composes, out of an as input given amino acid distribution,
a randomly sampled amino acid sequence. \code{\link{compose_GPGx8cTerm}},
\code{\link{compose_GSx7cTerm}}, and \code{\link{compose_GPx10R}} belong to
three groups composing different flycode (peptide) construction.
The construction is given in the function name. For example, GPGx8cTerm,
composes a flycode having as prefix GPG followed by eight (x8) amino acids
followed by a cTerm sequence. The different construction will have different
detectability properties as mass range and hydrophobicity values.
}
\examples{
set.seed(1)
aa_pool_1_2_9_10 <- c(rep('A', 8), rep('S', 7), rep('T', 7), rep('N', 6),
rep('Q', 6), rep('D', 8), rep('E', 8), rep('V', 9), rep('L', 6), rep('F', 5),
rep('Y', 9), rep('W', 6), rep('G', 15), rep('P', 0))

aa_pool_3_8 <- c(rep('A', 5), rep('S', 4), rep('T', 5), rep('N', 2),
rep('Q', 2), rep('D', 8), rep('E', 8), rep('V', 7), rep('L', 5), rep('F', 4),
rep('Y', 6), rep('W', 4), rep('G', 12), rep('P', 28))

compose_GPx10R(aa_pool_1_2_9_10, aa_pool_3_8)
(FlyCodes <- replicate(10, compose_GPx10R(aa_pool_1_2_9_10, aa_pool_3_8)))
plot(parentIonMass(FlyCodes) ~ssrc(FlyCodes))
}
\author{
Christian Panse <cp@fgcz.ethz.ch> 2015
}
