% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MicrobiomeBenchmarkData.R
\name{getBenchmarkData}
\alias{getBenchmarkData}
\title{Get dataset}
\usage{
getBenchmarkData(x, dryrun = TRUE)
}
\arguments{
\item{x}{A character vector with the name(s) of the dataset(s). If empty
and dryrun = TRUE, it returns a message with the names of the available
datasets. If empty and dryrun = FALSE, it returns a list of
TreeSummarizedExperiments with all of the datasets.}

\item{dryrun}{If TRUE, only returns a message and invisibly returns the
names of the datasets as a character vector. If FALSE, it returns the
TreeSummarizedExperiment datasets indicated in the argument 'x'.}
}
\value{
A list of TreeSummarizedExperiments when dryrun = FALSE. A data
frame with the datasets characteristics when dryrun = TRUE.
}
\description{
\code{getBenchmarkData} imports datasets as TreeSummarizedExperiment objects.
}
\examples{

## Example 1
datasets_names <- getBenchmarkData()
datasets_names

## Example 2
dataset <- getBenchmarkData(
    "HMP_2012_16S_gingival_V35_subset", dryrun = FALSE
)
dataset[[1]]

}
