% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_refseq_16S.R
\name{download_refseq_16S}
\alias{download_refseq_16S}
\title{Download RefSeq 16S rRNA Bacterial and Archael libraries}
\usage{
download_refseq_16S(out_dir, combined_name = "refseq_16S.fna")
}
\arguments{
\item{out_dir}{Character string giving the name of the directory to which
libraries should be output. **Required**}

\item{combined_name}{Name of output combined file. Default is
\code{"refseq_16S.fna"}}
}
\value{
Returns a character string of the path to the combined 16S rRNA .fna
   file
}
\description{
This function will automatically download the 16S rRNA RefSeq libraries from
\code{https://ftp.ncbi.nlm.nih.gov/refseq/TargetedLoci/} and combine them
into a single .fna file
}
\note{
This function requires the suggested packages \pkg{RCurl} and
   \pkg{R.utils}. If they are not installed, you will need to install
   them manually.
}
\examples{
\dontrun{
#### Download 16S rRNA Genomes

download_refseq_16S(out_dir = "out_dir",
  combined_name = "refseq_16S.fna")
  }
}
