% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_refseq.R
\name{download_refseq}
\alias{download_refseq}
\title{Download RefSeq genome libraries}
\usage{
download_refseq(
  taxon,
  reference = TRUE,
  representative = FALSE,
  compress = TRUE,
  patho_out = FALSE,
  out_dir = NULL,
  caching = FALSE,
  quiet = TRUE,
  accession_path = NULL
)
}
\arguments{
\item{taxon}{Name of single taxon to download. The taxon name should be a
recognized NCBI scientific or common name, with no grammatical or
capitalization inconsistencies. All available taxonomies are visible by
accessing the \code{MetaScope:::taxonomy_table} object included in the package.}

\item{reference}{Download only RefSeq reference genomes? Defaults to
\code{TRUE}. Automatically set to \code{TRUE} if \code{representative =
TRUE}.}

\item{representative}{Download RefSeq representative and reference genomes?
Defaults to \code{FALSE}. If \code{TRUE}, reference is automatically set at
  \code{TRUE}.}

\item{compress}{Compress the output .fasta file? Defaults to \code{TRUE}.}

\item{patho_out}{Create duplicate outpute files compatible with PathoScope?
Defaults to \code{FALSE}.}

\item{out_dir}{Character string giving the name of the directory to which
libraries should be output. Defaults to creation of a new temporary
directory.}

\item{caching}{Whether to use BiocFileCache when downloading genomes.
Default is \code{FALSE}.}

\item{quiet}{Turns off most messages. Default is \code{TRUE}.}

\item{accession_path}{(character) Filepath to NCBI accessions SQL
database. See \code{taxonomzr::prepareDatabase()}.}
}
\value{
Returns a .fasta or .fasta.gz file of the desired RefSeq genomes.
This file is named after the kingdom selected and saved to the current
directory (e.g. 'bacteria.fasta.gz'). This function also has the option
to return a .fasta file formatted for PathoScope as well
(e.g. bacteria.pathoscope.fasta.gz') if \code{path_out = TRUE}.
}
\description{
This function will automatically download RefSeq genome libraries in a fasta
format from the specified taxon. The function will first download the
summary report at:
\code{ftp://ftp.ncbi.nlm.nih.gov/genomes/refseq/**kingdom**/assembly_summary.txt},
and then use this file to download the genome(s) and combine them in a
single compressed or uncompressed .fasta file.
}
\details{
When selecting the \code{taxon} to be downloaded, if you receive an error
saying \code{Your input is not a valid taxon}, please take a look at the
\code{taxonomy_table} object, which can be accessed with the command
\code{MetaScope:::taxonomy_table)}. Only taxa with exact spelling as they appear
at any level of the table will be acknowledged.
}
\examples{
#### Download RefSeq genomes

## Create temporary taxonomizr accession
tmp_accession <- system.file("extdata", "example_accessions.sql", package = "MetaScope")

## Download all RefSeq reference Bovismacovirus genus genomes
download_refseq('Bovismacovirus', reference = FALSE, representative = FALSE,
                out_dir = NULL, compress = TRUE, patho_out = FALSE,
                caching = TRUE, accession_path = tmp_accession)
}
