% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metascope_blast.R
\name{blastn_results}
\alias{blastn_results}
\title{Reformat BLASTn results}
\usage{
blastn_results(
  results_table,
  bam_file,
  num_results = 10,
  num_reads_per_result = 100,
  hit_list = 10,
  num_threads = 1,
  db_path,
  out_path,
  db = NULL,
  sample_name = NULL,
  quiet = quiet,
  accession_path,
  fasta_dir = NULL,
  BPPARAM
)
}
\arguments{
\item{results_table}{data.frame containing the MetaScope results.}

\item{bam_file}{\code{Rsamtools::bamFile} instance for the given sample.}

\item{num_results}{Integer; maximum number of Metascope results to BLAST.
Default is 10.}

\item{num_reads_per_result}{Integer; number of reads to BLAST per result.
Default is 100.}

\item{hit_list}{Integer; how many BLAST results to fetch for each read.
Default is 10.}

\item{num_threads}{Integer; how many threads to use if multithreading.
Default is 1.}

\item{db_path}{Character string; filepath for the location of the
pre-installed BLAST database.}

\item{out_path}{Character string; Output directory to save CSV output files,
including base name of files. For example, given a sample "X78256",
filepath would be \code{file.path(directory_here, "X78256")} with extension
omitted.}

\item{db}{Currently accepts one of \code{c("ncbi", "silva", "other")} Default
is \code{"ncbi"}, appropriate for samples aligned against indices compiled
from NCBI whole genome databases. Alternatively, usage of an alternate
database (like Greengenes2) should be specified with \code{"other"}.}

\item{sample_name}{Character string, sample name for output files.}

\item{quiet}{Logical, whether to print out more informative messages. Default
is FALSE.}

\item{accession_path}{(character) Filepath to NCBI accessions SQL
database. See \code{taxonomzr::prepareDatabase()}.}

\item{fasta_dir}{Character string; Directory where fastas from
\code{metascope_id} are stored.}

\item{BPPARAM}{An optional BiocParallelParam instance determining the
parallel back-end to be used during evaluation.}
}
\value{
Creates and exports num_results number of csv files with blast
  results from local blast
}
\description{
Reformat BLASTn results
}
