% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_alluvial.R
\name{plot_alluvial}
\alias{plot_alluvial}
\title{Plot an alluvial diagram of microbial relative abundance}
\usage{
plot_alluvial(
  dat,
  taxon_level,
  covariate_1 = NULL,
  covariate_time,
  palette_input = NULL,
  title = paste("Relative abundance at", taxon_level, "level"),
  subtitle = NULL
)
}
\arguments{
\item{dat}{A \code{MultiAssayExperiment} object specially formatted as an
animalcules output.}

\item{taxon_level}{Character string indicating the level of taxonomy to
aggregate the counts data. Must be the name of a column in
\code{MultiAssayExperiment::rowData(dat)}.}

\item{covariate_1}{Character string giving the name of a column in
\code{MultiAssayExperiment::colData(dat)} on which to create multiple
plots. The default is \code{NULL}.}

\item{covariate_time}{Character string giving the name of the discrete
time-based covariate in the metadata to group abundances by.}

\item{palette_input}{A character vector of colors that is at minimum the same
length of the number of taxa (specified with \code{taxon_level}).
The default is \code{NULL} and relies on \code{ggplot2}'s default scheme.}

\item{title}{A character string providing the plot title.}

\item{subtitle}{A character string providing the plot subtitle. The default
is \code{NULL}.}
}
\value{
A \code{ggplot2} plot.
}
\description{
This function takes a \code{MultiAssayExperiment} object and returns a
alluvial diagram of microbe relative abundances. The function takes a single
covariate as an optional variable by which to create a grid of multiple
plots. Note, the ggalluvial package is required to use this function.
}
\details{
If further manipulation of specific parameters is desired, users can add
\code{ggplot2} function calls to the output of the function.
}
\examples{
in_dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
plot_alluvial(in_dat, taxon_level = "family", covariate_1 = "Group", covariate_time = "Month",
              palette_input = rainbow(25))

}
