% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_formatted_MAE.R
\name{create_formatted_MAE}
\alias{create_formatted_MAE}
\title{Create a formatted MultiAssayExperiment compatible with LegATo}
\usage{
create_formatted_MAE(
  counts_dat = NULL,
  tax_dat = NULL,
  metadata_dat = NULL,
  tree_SE = NULL
)
}
\arguments{
\item{counts_dat}{A matrix, data.table, or data.frame consisting of microbial
raw counts data. The \code{colnames} should be sample names and the
\code{rownames} should be in the same order as the \code{tax_dat} entries.
Not required if \code{tree_SE} is passed in.}

\item{tax_dat}{A matrix, data.table, or data.frame of hierarchical taxonomic
data. Should have columns such as "family", "genus", "species" with each
row uniquely delineating a different taxon. The rows should be in the same
order as the rows of \code{counts_dat}. Not required if \code{tree_SE} is
passed in.}

\item{metadata_dat}{A metadata table with \code{rownames} equivalent to the
samples that are the \code{colnames} of the \code{counts_dat}. Not required
if \code{tree_SE} is passed in.}

\item{tree_SE}{A TreeSummarizedExperiment object with counts, taxonomy, and
metadata.}
}
\value{
A \code{MultiAssayExperiment} object.
}
\description{
This function takes either a counts_dat, tax_dat, and metadata_dat input OR
a TreeSummarizedExperiment input and creates
a specifically-formatted MAE object that is compatible for use with LegATo
and animalcules. Checks are performed on inputs to ensure that they can be
integrated properly.
}
\examples{
nsample <- ntaxa <- 3
counts_dat <- data.frame(
    "X123" = runif(ntaxa, 0, 500),
    "X456" = runif(ntaxa, 0, 500),
    "X789" = runif(ntaxa, 0, 500)
)
tax_dat <- data.frame(
    "class" = c("rand1", "rand2", "rand3"),
    "species" = c("rand4", "rand5", "rand6")
) |>
    as.data.frame()
# Set rownames as lowest unique taxonomic level
rownames(tax_dat) <- tax_dat$species
rownames(counts_dat) <- tax_dat$species
metadata <- data.frame(
    Sample = c("X123", "X456", "X789"),
    Group = c("A", "B", "A"),
    Var = rnorm(nsample)
)
rownames(metadata) <- metadata$Sample
out_MAE <- create_formatted_MAE(counts_dat, tax_dat, metadata)

# TreeSummarizedExperiment
tse <- TreeSummarizedExperiment::TreeSummarizedExperiment(
    assays = list(counts = counts_dat),
    colData = metadata,            
    rowData = tax_dat             
)
out_MAE_2 <- create_formatted_MAE(tree_SE = tse)
out_MAE_2
}
