% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_MAE.R
\name{clean_MAE}
\alias{clean_MAE}
\title{Clean up taxon names in a MultiAssayExperiment}
\usage{
clean_MAE(dat, which_experiment = NULL, which_assay = NULL)
}
\arguments{
\item{dat}{A \code{MultiAssayExperiment} object specially formatted as an
animalcules output.}

\item{which_experiment}{Character string. If \code{type = "MAE"}, then
this is the name of the experiment to be accessed. If \code{NULL},
will default to the first available experiment.}

\item{which_assay}{Character string. Regardless of whether 
\code{type = "MAE"} or \code{"SE"}, this is the name of the selected
\code{SummarizedExperiment} object. If \code{NULL}, defaults to first listed.}
}
\value{
An animalcules-formatted \code{MultiAssayExperiment} object with
  cleaned-up taxonomy nomenclature.
}
\description{
This functional is an optional method for fixing up taxon names in a
\code{MultiAssayExperiment} to be run before \code{filter_MAE}.
Specifically, it removes brackets from species names, replaces species labeled
as "others" with "sp." and finally replaces underscores with spaces.
}
\examples{
in_dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
clean_MAE(in_dat)

}
