% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_phosphosites.R
\name{getScoreMaps}
\alias{getScoreMaps}
\title{Map log2-odds score to percentile rank}
\usage{
getScoreMaps()
}
\value{
A named list of functions, one for each kinase PWM. Each function is
taking a vector of log2-odds scores as input and returns the corresponding
percentile ranks.
}
\description{
For each kinase PWM, get a function that maps its log2-odds score to the
percentile rank in the background score distribution. The percentile rank of
a given score is the percentage of scores in corresponding background score
distribution that are less than or equal to that score. The background score
distribution per PWM is derived from matching each PWM to either the 85'603
unique phosphosites published in Johnson et al. 2023 (serine/threonine PWMs)
or the 6659 unique phosphosites published in Yaron-Barir et al. 2024
(tyrosine PWMs).
}
\details{
Note: since the background sites don't contain non-central phosphorylated
residues (phospho-priming), the percentile rank of an input site which
includes phospho-priming will be capped to 100, if its PWM score exceeds the
largest observed background score for that PWM.

Internally, \link[stats:approxfun]{stats::approxfun} is used to linearly interpolate between the
PWM score and its 0.1\% - quantile in the distribution over background scores.
This approximation allows for a lower memory footprint compared with the full
set of background scores.
}
\examples{
maps <- getScoreMaps()
}
