% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{getKinaseAnnotation}
\alias{getKinaseAnnotation}
\title{Get annnotation data for all kinase PWMs}
\usage{
getKinaseAnnotation()
}
\value{
A data frame with columns MatrixName, GeneName, UniprotID, EntrezID,
Description, AcceptorSpecificity, KinaseSubType and KinaseFamily
}
\description{
The annotation data records for each kinase PWM, the PWM matrix name, gene
symbol and description, Uniprot ID, Entrez ID, acceptor specificity, kinase
sub-type, as well as the kinase family.
}
\details{
Kinase PWMs are either serine/threonine or tyrosine specific in their central
phospho-acceptor. For dual-specific kinases, the tyrosine-specific PWM is
indicated by the '_TYR' suffix in the PWM name.

Tyrosine kinases are further distinguished by sub-type and include receptor
tyrosine kinases (RTK), non-receptor tyrosine kinases (nRTK) and
non-canonical tyrosine kinases (ncTK) with dual-specificity.
}
\examples{
anno <- getKinaseAnnotation()
}
