% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{pretty_legend}
\alias{pretty_legend}
\title{helper function to create nice legends}
\usage{
pretty_legend(gg, last_vals, xmin, fontsize = 13)
}
\arguments{
\item{gg}{ggplot2 object}

\item{last_vals, }{data frame with columns 
label, colour, last_vals (i.e. place label with colour at y-coordinate last_vals)}

\item{xmin}{Numeric, x axis position at which labels should be placed}

\item{fontsize}{Integer, fontsize}
}
\value{
Another ggplot2 object

     This replaces the default legend of a ggplot2 object. In particular,
   given a ggplot2 object ,it removes the existing legend and then places
   new labels based on the annotation data frame `last_vals` (see parameter description)
   at a given x-coordinate of the original plot.

   This function can be attributed to and is described in more detail in 
   the following blog post:
   http://www.r-bloggers.com/coloring-and-drawing-outside-the-lines-in-ggplot/
}
\description{
helper function to create nice legends
}
\examples{
  library("ggplot2")
  labels  <- c("A","B","C")
  mypoints <- rbind(data.frame(y=1:3, x=1, label=as.factor(labels)),
                     data.frame(y=2:4, x=2, label=as.factor(labels)))
  mycolours <- c("#F8766D","#00BA38","#619CFF")
  gg <- ggplot(mypoints,aes(x=x,y=y,color=label)) + 
               geom_line(size=2) + 
               scale_color_manual(values=mycolours) +
               xlim(c(0,2.2))
  gg
  annotation_df <- data.frame(colour=mycolours, last_vals=2:4, label=labels)
  pretty_legend(gg, annotation_df, 2.1)

}
