metadata <- rbind(data.frame(
    Title = "GEO accession data GSE64985 as an ExpressionSet",
    Description = paste0("Re-analysis of human gene expression data generated on ",
                         "the Affymetrix HG_U133PlusV2 platform. The original data ", 
                         "were downloaded from GEO on May 28, 2008 and normalized ",
                         "using robust multiarray averaging (RMA) to obtain an",
                         "integrated gene expression atlas across diverse biological ", 
                         "sample types and conditions. The entire compendium comprises ",
                         "20,099 genes and 9395 arrays."),
    BiocVersion = "3.3",
    Genome = "hg19",
    SourceType = "tar.gz",
    SourceUrl = "http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE64985",
    SourceVersion = "Jan 15 2015",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "GEO",
    Maintainer = "Brad Nelms <bnelms.research@gmail.com>",
    RDataClass = "ExpressionSet",
    DispatchClass = "ExpressionSet",
    Tags = "ExperimentData, MicroarrayData, ExpressionData",
    ResourceName = "GSE64985.rda"
),

data.frame(
    Title = "ArrayExpress accession data E-MTAB-62 as an ExpressionSet",
    Description = "Re-analysis of human gene expression data generated on the Affymetrix HG_U133A platform. The original data were normalized using robust multiarray averaging (RMA) to obtain an integrated gene expression atlas across diverse biological sample types and conditions. Normalized data was further processed using the R package bias 0.0.3 to reduce the impace of technical bias on the dataset. The entire compendium comprises 5372 arrays.",
    BiocVersion = "3.3",
    Genome = "hg19",
    SourceType = "tar.gz",
    SourceUrl = "https://www.ebi.ac.uk/arrayexpress/experiments/E-MTAB-62/",
    SourceVersion = "August 4 2010",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "ArrayExpress",
    Maintainer = "Brad Nelms <bnelms.research@gmail.com>",
    RDataClass = "ExpressionSet",
    DispatchClass = "ExpressionSet",
    Tags = "ExperimentData, MicroarrayData, ExpressionData",
    ResourceName = "E.MTAB.62.rda"
))

write.csv(metadata, file="metadata.csv", row.names=FALSE)
