% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCAData.R
\name{HCAData}
\alias{HCAData}
\title{Download data from the HCA via ExperimentHub}
\usage{
HCAData(dataset = NULL, as.sparse = TRUE)
}
\arguments{
\item{dataset}{A character string: which dataset should be retrieved?}

\item{as.sparse}{Logical, specifies whether the underlying HDF5 dataset should
be treated as sparse or not - will be passed to the call to \code{HDF5Array()}.
Defaults to TRUE, i.e. by using the \code{DelayedArray} infrastructure.}
}
\value{
A SingleCellExperiment object with a HDF5Matrix in the \code{counts}
assay, containing the UMI counts for each gene in each cell. Row- and column-level
metadata are also provided.
}
\description{
Download HDF5 (dense assay) and RDS (row and column annotations)
files from the HCA via ExperimentHub, composing them together as a
SingleCellExperiment object
}
\details{
This current release includes the following datasets:
\describe{
\item{Census of Immune Cells - Umbilical cord blood}{UMI counts from the 10x
(droplet) single-cell RNA-seq data. The object contains counts for 33694 genes
in 384000 cells.}
\item{Census of Immune Cells - Bone marrow}{UMI counts from the 10x
(droplet) single-cell RNA-seq data. The object contains counts for 33694 genes
in 378000 cells.}
}
}
\examples{
HCAData()
sce_cordblood <- HCAData("ica_cord_blood")
}
