% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{Exp1_R25_prot}
\alias{Exp1_R25_prot}
\title{Exp1_R25_prot dataset}
\format{
An object of class \code{MSnSet} related to proteins
quantification. It contains 6 samples divided into two conditions
(25 fmol and 10 fmol) and 2384 proteins.

The data frame exprs(Exp1_R25_prot) contains six columns that are the 
quantitation of proteins for the six replicates. 

The data frame fData(Exp1_R25_prot) contains the meta data about the 
proteins.

The data frame pData(Exp1_R25_prot) contains the experimental design and 
gives few informations about the samples.
}
\usage{
data(Exp1_R25_prot)
}
\value{
An object of class \code{MSnSet} related to proteins
quantification.
}
\description{
This dataset is the final outcome of a quantitative mass 
spectrometry-based proteomic analysis of two samples containing different 
concentrations of 48 human proteins (UPS1 standard from Sigma-Aldrich) 
within a constant yeast background (see Giai Gianetto et al. (2016) for 
details). It contains the abundance values of the different human and 
yeast proteins identified and quantified in these two conditions. The two 
conditions represent the measured abundances of proteins when respectively 
25 fmol and 10 fmol of UPS1 human proteins were mixed with the yeast extract 
before mass spectrometry analyses. This results in a concentration ratio of 
2.5. Three technical replicates were acquired 
for each condition.

The dataset is either available as a CSV file 
(see inst/extdata/Exp1_R25_prot.txt), or as a \code{MSnSet} structure 
(Exp1_R25_prot.MSnset). In the latter case, the quantitative data are those 
of the raw intensities.
}
\references{
Cox J., Hein M.Y., Luber C.A., Paron I., Nagaraj N., Mann M. 
Accurate proteome-wide label-free quantification by delayed normalization 
and maximal peptide ratio extraction, termed MaxLFQ. Mol Cell Proteomics. 
2014 Sep, 13(9):2513-26.

Giai Gianetto, Q., Combes, F., Ramus, C., Bruley, C., Coute, Y., Burger, 
T. (2016). Calibration plot for proteomics: A graphical tool to visually 
check the assumptions underlying FDR control in quantitative experiments. 
Proteomics, 16(1), 29-32.
}
\keyword{data}
\keyword{datasets}
