metadata <- rbind(data.frame(
    Title = "Pre-processed microarray data from the Allen Brain Atlas",
    Description = "Large collection of microarrays on microdissected human brain samples from the Allen Brain Atlas, pre-processed for use with the CellMapper R package.",
    BiocVersion = "3.3",
    Genome = "hg19",
    SourceType = "tar.gz",
    SourceUrl = "http://human.brain-map.org/static/download",
    SourceVersion = "February 2014",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "Allen Brain Atlas",
    Maintainer = "Brad Nelms <bnelms.research@gmail.com>",
    RDataClass = "CellMapperList",
    DispatchClass = "Rda",
    Tags = "ExperimentData, MicroarrayData, ExpressionData",
    ResourceName = "BrainAtlas.rda"
),

data.frame(
    Title = "Pre-processed microarray data from the Affymetrix HG-U133PlusV2 platform",
    Description = "Large collection of microarrays from the human Affymetrix HG-U133PlusV2 platform, pre-processed for use with the CellMapper R package.",
    BiocVersion = "3.3",
    Genome = "hg19",
    SourceType = "tar.gz",
    SourceUrl = "http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE64985",
    SourceVersion = "Jan 15 2015",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "GEO",
    Maintainer = "Brad Nelms <bnelms.research@gmail.com>",
    RDataClass = "CellMapperList",
    DispatchClass = "Rda",
    Tags = "ExperimentData, MicroarrayData, ExpressionData",
    ResourceName = "Engreitz.rda"
),

data.frame(
    Title = "Pre-processed microarray data from the Affymetrix HG-U133A platform",
    Description = "Large collection of microarrays from the human Affymetrix HG-U133A platform, pre-processed for use with the CellMapper R package.",
    BiocVersion = "3.3",
    Genome = "hg19",
    SourceType = "tar.gz",
    SourceUrl = "https://www.ebi.ac.uk/arrayexpress/experiments/E-MTAB-62/",
    SourceVersion = "August 4 2010",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "ArrayExpress",
    Maintainer = "Brad Nelms <bnelms.research@gmail.com>",
    RDataClass = "CellMapperList",
    DispatchClass = "Rda",
    Tags = "ExperimentData, MicroarrayData, ExpressionData",
    ResourceName = "Lukk.rda"
),

data.frame(
    Title = "Pre-processed microarray data from the Affymetrix MG-U74Av2 platform",
    Description = "Large collection of microarrays from the human Affymetrix MG-U74Av2 platform, pre-processed for use with the CellMapper R package. Mouse gene identifiers were mapped to their human orthologs, and human Entrez IDs should be used to refer to genes when using this dataset.",
    BiocVersion = "3.3",
    Genome = "mm9",
    SourceType = "tar.gz",
    SourceUrl = "https://www.ebi.ac.uk/arrayexpress/experiments/E-MTAB-27/",
    SourceVersion = "November 26 2009",
    Species = "Mus musculus",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "ArrayExpress",
    Maintainer = "Brad Nelms <bnelms.research@gmail.com>",
    RDataClass = "CellMapperList",
    DispatchClass = "Rda",
    Tags = "ExperimentData, MicroarrayData, ExpressionData",
    ResourceName = "ZhengBradley.rda"
),

data.frame(
    Title = "Pre-processed microarray data from the human small and large intestine",
    Description = "Large collection of microarrays from the human small and large intestine, pre-processed for use with the CellMapper R package. Data is an intestine-specific subset of samples from the GSE64985 and E-MTAB-62 microarray compendia, see CellMapper package vignette for details.",
    BiocVersion = "3.3",
    Genome = "hg19",
    SourceType = "tar.gz",
    SourceUrl = "http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE64985, https://www.ebi.ac.uk/arrayexpress/experiments/E-MTAB-62/",
    SourceVersion = "July 1 2016",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "GEO",
    Maintainer = "Brad Nelms <bnelms.research@gmail.com>",
    RDataClass = "CellMapperList",
    DispatchClass = "Rda",
    Tags = "ExperimentData, MicroarrayData, ExpressionData",
    ResourceName = "Intestine.rda"
),

data.frame(
    Title = "Pre-processed microarray data from the human kidney",
    Description = "Large collection of microarrays from the human kidney, pre-processed for use with the CellMapper R package.",
    BiocVersion = "3.3",
    Genome = "hg19",
    SourceType = "tar.gz",
    SourceUrl = "http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE32691; see also acc=GSE35488, acc=GSE37455, acc=GSE37460, acc=GSE47185",
    SourceVersion = "Feb 2 2012 - August 6 2013",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "GEO",
    Maintainer = "Brad Nelms <bnelms.research@gmail.com>",
    RDataClass = "CellMapperList",
    DispatchClass = "Rda",
    Tags = "ExperimentData, MicroarrayData, ExpressionData",
    ResourceName = "Kidney.rda"
))

write.csv(metadata, file="metadata.csv", row.names=FALSE)
