% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioplex.R
\name{mapSummarizedExperimentOntoGraph}
\alias{mapSummarizedExperimentOntoGraph}
\title{Map experimental data onto a graph}
\usage{
mapSummarizedExperimentOntoGraph(
  gr,
  se,
  col.names = NULL,
  rowdata.cols = NULL,
  prefix = ""
)
}
\arguments{
\item{gr}{an object of class \code{\linkS4class{graph}}.}

\item{se}{an object of class \code{\linkS4class{SummarizedExperiment}}.}

\item{col.names}{character. Column names of \code{se} for which assay
data should be mapped onto the nodes of \code{gr}. Defaults to \code{NULL}
which will then use all column names of \code{se}.}

\item{rowdata.cols}{character. Column names of \code{rowData(se)} which
should be mapped onto the nodes of \code{gr}. Defaults to \code{NULL}
which will then use all column names of \code{rowData(se)}.}

\item{prefix}{character. Informative prefix that should be pasted together
with the selected \code{col.names} and \code{rowdata.cols} to allow easy
identification of columns of interest when mapping from multiple experimental
datasets.}
}
\value{
An object of class \code{\linkS4class{graph}}.
}
\description{
Functionality for mapping experimental data stored in
a \code{\linkS4class{SummarizedExperiment}} onto a
\code{\linkS4class{graph}} object.
}
\examples{
# (1) Obtain the latest version of the 293T PPI network ...
bp.293t <- getBioPlex(cell.line = "293T", version = "3.0")

# (2) ... and turn into a graph
bp.gr <- bioplex2graph(bp.293t)

# (3) Obtain the BioPlex3 proteome data ...
se <- getBioplexProteome()

# (4) ... and map onto the graph
bp.gr <- mapSummarizedExperimentOntoGraph(bp.gr, se)
}
