% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioplex.R
\name{annotatePFAM}
\alias{annotatePFAM}
\title{Annotate PFAM domains to BioPlex PPI graph}
\usage{
annotatePFAM(bp.gr, orgdb)
}
\arguments{
\item{bp.gr}{an object of class \code{\linkS4class{graph}} storing the
BioPlex PPIs. Typically obtained via \code{\link{bioplex2graph}}.}

\item{orgdb}{an \code{orgdb} object storing annotation data for human.}
}
\value{
An object of class \code{graphNEL} containing PFAM domain annotations
in the \code{nodeData}.
}
\description{
This function adds PFAM domain annotations to the node metadata
of the BioPlex PPI graph.
}
\examples{
# (1) Obtain the latest version of the 293T PPI network
bp.293t <- getBioPlex(cell.line = "293T", version = "3.0")

# (2) Turn the data into a graph 
bp.gr <- bioplex2graph(bp.293t)

# (3) Obtain orgdb package from AnnotationHub
ah <- AnnotationHub::AnnotationHub()
orgdb <- AnnotationHub::query(ah, c("orgDb", "Homo sapiens"))
orgdb <- orgdb[[1]]

# (4) Annotate PFAM domains
bp.gr <- annotatePFAM(bp.gr, orgdb)

}
\references{
BioPlex: \url{https://bioplex.hms.harvard.edu/interactions.php}

PFAM: \url{http://pfam.xfam.org}
}
\seealso{
\code{\link{nodeData}}
}
