\name{reactome_dbconn}

\alias{reactome_dbconn}
\alias{reactome_dbfile}
\alias{reactome_dbschema}
\alias{reactome_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  reactome_dbconn()
  reactome_dbfile()
  reactome_dbschema(file="", show.indices=FALSE)
  reactome_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{reactome_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{reactome_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{reactome_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{reactome_dbschema} prints the schema definition of the
  package annotation DB.

  \code{reactome_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{reactome_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{reactome_dbfile}: a character string with the path to the
  package annotation DB.

  \code{reactome_dbschema}: none (invisible \code{NULL}).

  \code{reactome_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(RSQLite)
  ## Count the number of rows in the "pathway2name" table:
  dbGetQuery(reactome_dbconn(), "SELECT COUNT(*) FROM pathway2name")

  ## The connection object returned by reactome_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=reactome_dbfile(), cache_size=64000,
  synchronous="off")

  reactome_dbschema()

  reactome_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

