datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Xl.eg <- function() showQCData("org.Xl.eg", datacache)
org.Xl.eg_dbconn <- function() dbconn(datacache)
org.Xl.eg_dbfile <- function() dbfile(datacache)
org.Xl.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Xl.eg_dbInfo <- function() dbInfo(datacache)

org.Xl.egORGANISM <- "Xenopus laevis"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Xl.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("XENOPUS_DB", "org.Xl.eg", "Xenopus", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Xl.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Xl.eg_dbconn())
}

