datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Ss.eg <- function() showQCData("org.Ss.eg", datacache)
org.Ss.eg_dbconn <- function() dbconn(datacache)
org.Ss.eg_dbfile <- function() dbfile(datacache)
org.Ss.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Ss.eg_dbInfo <- function() dbInfo(datacache)

org.Ss.egORGANISM <- "Sus scrofa"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Ss.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("PIG_DB", "org.Ss.eg", "Pig", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Ss.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Ss.eg_dbconn())
}

