datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Dm.eg <- function() showQCData("org.Dm.eg", datacache)
org.Dm.eg_dbconn <- function() dbconn(datacache)
org.Dm.eg_dbfile <- function() dbfile(datacache)
org.Dm.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Dm.eg_dbInfo <- function() dbInfo(datacache)

org.Dm.egORGANISM <- "Drosophila melanogaster"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Dm.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("FLY_DB", "org.Dm.eg", "Fly", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Dm.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Dm.eg_dbconn())
}

