datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Ce.eg <- function() showQCData("org.Ce.eg", datacache)
org.Ce.eg_dbconn <- function() dbconn(datacache)
org.Ce.eg_dbfile <- function() dbfile(datacache)
org.Ce.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Ce.eg_dbInfo <- function() dbInfo(datacache)

org.Ce.egORGANISM <- "Caenorhabditis elegans"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Ce.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("WORM_DB", "org.Ce.eg", "Worm", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Ce.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Ce.eg_dbconn())
}

