datacache <- new.env(hash=TRUE, parent=emptyenv())

clariomsmousehttranscriptcluster <- function() showQCData("clariomsmousehttranscriptcluster", datacache)
clariomsmousehttranscriptcluster_dbconn <- function() dbconn(datacache)
clariomsmousehttranscriptcluster_dbfile <- function() dbfile(datacache)
clariomsmousehttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
clariomsmousehttranscriptcluster_dbInfo <- function() dbInfo(datacache)

clariomsmousehttranscriptclusterORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "clariomsmousehttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "clariomsmousehttranscriptcluster", "chip clariomsmousehttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("clariomsmousehttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(clariomsmousehttranscriptcluster_dbconn())
}

