\name{IlluminaHumanMethylation27k_getProbes}
\alias{IlluminaHumanMethylation27k_getProbes}

\title{Retrieve probe addresses by design and/or color channel for processing}

\description{
  A convenience function to retrieve probe addresses by design or color channel.
}

\usage{
  IlluminaHumanMethylation27k_getProbes(color=NULL, design='I')
}

\arguments{
  \item{color}{
    Optional color for design I.  If NULL, both will be returned as a list.
  }
  \item{design}{
    Optional probe design type. If NULL, both will be returned in a list.
  }
}

\details{
  \code{IlluminaHumanMethylation27k_getProbes} simply queries a VIEW in the 
  SQLite database accompanying this package to obtain probe addresses en masse.
}

\value{
  If no arguments are provided, a list of two data frames for probes, one for 
  each color channel.  If arguments are provided, the value depends on them.
}

\seealso{
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{

  ## Get both channels' worth of probes for processing IDAT files
  IlluminaHumanMethylation27k_getProbes(color='Red')

}

\keyword{utilities}
\keyword{datasets}
