\name{IlluminaHumanMethylation27k_getControls}
\alias{IlluminaHumanMethylation27k_getControls}

\title{Retrieve control probe addresses, optionally by control probe type}

\description{
  A convenience function to retrieve addresses of Illumina control probes.
}

\usage{
  IlluminaHumanMethylation27k_getControls(type=NULL)
}

\arguments{
  \item{type}{
    Optional control probe type. If NULL, all control probes will be returned.
  }
}

\details{
  \code{IlluminaHumanMethylation27k_getControls} simply queries a VIEW in the 
  SQLite database accompanying this package to obtain control probe addresses.
}

\value{
  A data.frame with fields Address and Type for each probe returned.
}

\seealso{
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{

  ## Get all the control probe addresses
  IlluminaHumanMethylation27k_getControls()

  ## Get only the bisulfite conversion controls
  IlluminaHumanMethylation27k_getControls('Bisulfite')

}

\keyword{utilities}
\keyword{datasets}
