\name{IlluminaHumanMethylation27kISCPGISLAND}
\alias{IlluminaHumanMethylation27kISCPGISLAND}
\title{Determine whether a probe is within a CpG island}
\description{
 IlluminaHumanMethylation27kISCPGISLAND is an R object that provides mappings between a
 manufacturer identifier and whether or not the CpG site being assayed meets 
 Illumina's criteria for being in a CpG island as defined by Illumina in the manifest.
}
\details{
  Value is a simple TRUE or FALSE for each probe, based simply on the Illumina manifest,
  TRUE meaning that the CpG site is within a CpG island.
  
  Mappings were based on data provided by: Illimina
  http://Illumina.com
  Downloaded 19-Sep-2009
  
}

\examples{
        x <- IlluminaHumanMethylation27kISCPGISLAND
        # Get the probe identifiers that are mapped
        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the values for the first five probes
          xx[1:5]
        }
}
\keyword{datasets}

