datacache <- new.env(hash=TRUE, parent=emptyenv())

IlluminaHumanMethylation27k <- function() showQCData("IlluminaHumanMethylation27k", datacache)
IlluminaHumanMethylation27k_dbconn <- function() dbconn(datacache)
IlluminaHumanMethylation27k_dbfile <- function() dbfile(datacache)
IlluminaHumanMethylation27k_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
IlluminaHumanMethylation27k_dbInfo <- function() dbInfo(datacache)

# these are from Sean, from the original 1.0 release through to 1.4.1
IlluminaHumanMethylation27kCPGCOORDINATE <- AnnotationDbi:::createSimpleBimap("cpgcoordinates","Probe_ID","CpG_Coordinate",datacache,"CPGCOORDINATE","IlluminaHumanMethylation27k.db")
IlluminaHumanMethylation27kDISTTOTSS <- AnnotationDbi:::createSimpleBimap("disttotss","Probe_ID","Dist_to_TSS",datacache,"DISTTOTSS","IlluminaHumanMethylation27k.db")
IlluminaHumanMethylation27kISCPGISLAND <- AnnotationDbi:::createSimpleBimap("iscpgisland","Probe_ID","CpG_island",datacache,"ISCPGISLAND","IlluminaHumanMethylation27k.db")
IlluminaHumanMethylation27kCOLORCHANNEL <- AnnotationDbi:::createSimpleBimap("colorchannel","Probe_ID","Color_Channel",datacache,"COLORCHANNEL","IlluminaHumanMethylation27k.db")

################# BEGIN ADDITIONS FROM TJT / USC EGC PEOPLE ####################

## sapply(SourceSeq, function(x) length(gregexpr('(GC|CG)',x)[[1]]))
IlluminaHumanMethylation27kCPGS <- AnnotationDbi:::createSimpleBimap("probedesign","Probe_ID","CpGs",datacache,"CPGS","IlluminaHumanMethylation27k.db")

## sapply(SourceSeq, seq2id)
IlluminaHumanMethylation27kNUID <- AnnotationDbi:::createSimpleBimap("probedesign","Probe_ID","NuID",datacache,"NUID","IlluminaHumanMethylation27k.db")

IlluminaHumanMethylation27k_getProbes <- function(color=NULL, design='I'){ # {{{

  channels <- list(R='Red',G='Grn')
  if(is.null(color)) {
    lapply(channels, function(ch) IlluminaHumanMethylation27k_getProbes(ch))
  } else {
    designSql <- 'SELECT Probe_ID, M, U, Color_Channel FROM probedesign1'
    designSql <- paste(designSql, " WHERE Color_Channel='",color,"'", sep='')
    dbGetQuery(IlluminaHumanMethylation27k_dbconn(), designSql)
  }

} # }}}

IlluminaHumanMethylation27k_getControls <- function(type=NULL) { # {{{

  controlSql <- 'SELECT * FROM controlprobes'
  if(!is.null(type)) {
    controlSql <- paste(controlSql," WHERE upper(Type) LIKE")
    controlSql <- paste(controlSql, paste("'%", toupper(type), "%'", sep=''))
  }
  dbGetQuery(IlluminaHumanMethylation27k_dbconn(), controlSql)

} # }}}

IlluminaHumanMethylation27k_getProbeOrdering <- function() { # {{{
  orderSql <- "SELECT p.Probe_ID,
                      'I' AS DESIGN,
                      c.Color_Channel AS COLOR_CHANNEL
                 FROM probedesign p, colorchannel c
                WHERE p.Probe_ID = c.Probe_ID
             ORDER BY p.row_names ASC"
  dbGetQuery(IlluminaHumanMethylation27k_dbconn(), orderSql)
} # }}}

################# SIMPLE IN-HOUSE REVISION TRACKING FOR EGC ####################

IlluminaHumanMethylation27kBLAME <- "$Author: ttriche $"
IlluminaHumanMethylation27kSVNID <- "$Id: zzz.R 1289 2011-05-04 18:59:15Z ttriche $"

################## END OF TJT ADDITIONS TO STOCK FUNCTIONS #####################

IlluminaHumanMethylation27kORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname) { # {{{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "IlluminaHumanMethylation27k.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "IlluminaHumanMethylation27k", "chip IlluminaHumanMethylation27k", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("IlluminaHumanMethylation27k.db"))
} # }}}

.onUnload <- function(libpath) { # {{{
    dbFileDisconnect(IlluminaHumanMethylation27k_dbconn())
} # }}}

