\name{GGHumanMethCancerPanelv1DISTTOTSS}
\alias{GGHumanMethCancerPanelv1DISTTOTSS}
\title{Map Manufacturer IDs to the distance to the transcript start of the nearest gene}
\description{
 GGHumanMethCancerPanelv1DISTTOTSS is an R object that provides mappings between a
 manufacturer identifier and the distance to the transcript start site of the nearest
 transcript, as defined by Illumina in the manifest.
}
\details{
  Simple probe mapping to CpG coordinate within the human genome, Build 36, as defined
  by Illumina.
  
  Mappings were based on data provided by: Illimina
  http://Illumina.com
  Downloaded 19-Sep-2009
  
}

\examples{
        x <- GGHumanMethCancerPanelv1DISTTOTSS
        # Get the probe identifiers that are mapped to disttotss
        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the value for the first five probes
          xx[1:5]
        }
}
\keyword{datasets}

