\name{BSgenome.Ptroglodytes.UCSC.panTro6}
\docType{package}

\alias{BSgenome.Ptroglodytes.UCSC.panTro6-package}
\alias{BSgenome.Ptroglodytes.UCSC.panTro6}
\alias{Ptroglodytes}

\title{Full genome sequences for Pan troglodytes (UCSC version panTro6)}

\description{
  Full genome sequences for Pan troglodytes (Chimp) as provided by UCSC (panTro6, Jan. 2018) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
panTro6.2bit from http://hgdownload.cse.ucsc.edu/goldenPath/panTro6/bigZips/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Ptroglodytes.UCSC.panTro6
genome <- BSgenome.Ptroglodytes.UCSC.panTro6
head(seqlengths(genome))
genome$chr1  # same as genome[["chr1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
