###
###

.pkgname <- "BSgenome.Ptroglodytes.UCSC.panTro6"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Pan troglodytes",
        common_name="Chimp",
        provider="UCSC",
        provider_version="panTro6",
        release_date="Jan. 2018",
        release_name="Clint_PTRv2",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/panTro6/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Ptroglodytes"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

