\name{BSgenome.Ppaniscus.UCSC.panPan1}
\docType{package}

\alias{BSgenome.Ppaniscus.UCSC.panPan1-package}
\alias{BSgenome.Ppaniscus.UCSC.panPan1}
\alias{Ppaniscus}

\title{Full genome sequences for Pan paniscus (UCSC version panPan1)}

\description{
  Full genome sequences for Pan paniscus (Bonobo) as provided by UCSC (panPan1, May 2012) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
panPan1.2bit from https://hgdownload.cse.ucsc.edu/goldenPath/panPan1/bigZips/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Ppaniscus.UCSC.panPan1
genome <- BSgenome.Ppaniscus.UCSC.panPan1
head(seqlengths(genome))
genome$AJFE01000001  # same as genome[["AJFE01000001"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
